require( "scripts/style.lua" );


MyFont = {
  standardFont,
  30,
  BlackColor
};

NameFont = {
  standardFont,
  20,
  BlackColor
};


MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/dialog",
		x=kCenter,
		y=kCenter,
		
		Text
		{
			font = MyFont,
			name = "enterlevel",
			x=0,y=20,w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "enterlevel"
		};
		
		Bitmap
		{
			image="backgrounds/textfield.png",
			x=kCenter,
			y=kCenter,
			
			TextEdit
			{
				font = NameFont,
				name = "nameedit",
				label = "",
				enablewindow = "enterok",
				clearinitial = deleteselected,
				x=3,y=5,w=kMax-3,h=kMax,
				length=12,
				ignore = kIllegalNameChars
				
			};
		};
			
		Button
		{
			x=50,
			y=-60,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="enterok",
			label="ok",
			type = kPush,
			default=true,	-- Make this the default button
			command = 
				function()
					CloseWindow(GetLabel("nameedit"));
				end
		},
		
		Button
		{
			x=250,
			y=-60,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="entercancel",
			label="cancel",
			type = kPush,
			command = 
				function()
					CloseWindow(nil);
				end
		};
	},
	
}

SetFocus( "nameedit" );



